#include <stdio.h>
#include <dir.h>
#include <string.h>
#include <malloc.h>
#include "isoloader.h"
#include "loader.h"
#include "param.h"
char* strlastof(const char* buffer, char last_c);

struct {
   char signature[4];
   char version[4];
   int offset[8];
} pbp_header = {
   { 0x00, 0x50, 0x42, 0x50 },
   { 0x00, 0x00, 0x01, 0x00 },
   { 40, 0, 0, 0, 0, 0, 0, 0 }
};

extern int iso_size;

int main(int argc, char** argv){
	if(!argv[1]){
		return 2;
	}

	FILE* fd = fopen(argv[1], "rb");
	IsoOpen(fd);
	printf("load ok\n");

	File dummy = { "", "", 0, 0, 0 };
	printf("GetFile(\"/PSP_GAME/ICON0.PNG\")\n");
	File* ICON0 = GetFile("/PSP_GAME/ICON0.PNG");
	printf("GetFile(\"/PSP_GAME/ICON1.PMF\")\n");
	File* ICON1 = GetFile("/PSP_GAME/ICON1.PMF");
	printf("GetFile(\"/PSP_GAME/PIC0.PNG\")\n");
	File* PIC0 = GetFile("/PSP_GAME/PIC0.PNG");
	printf("GetFile(\"/PSP_GAME/PIC1.PNG\")\n");
	File* PIC1 = GetFile("/PSP_GAME/PIC1.PNG");
	printf("GetFile(\"/PSP_GAME/SND0.AT3\")\n");
	File* SND0 = GetFile("/PSP_GAME/SND0.AT3");
	if((u32)ICON0&0x80000000)ICON0=&dummy;
	if((u32)ICON1&0x80000000)ICON1=&dummy;
	if((u32)PIC0&0x80000000)PIC0=&dummy;
	if((u32)PIC1&0x80000000)PIC1=&dummy;
	if((u32)SND0&0x80000000)SND0=&dummy;
	printf("\nICON0.PNG :\n");
	printf("  addr: 0x%08X\n", ICON0->addr);
	printf("  size: 0x%08X\n", ICON0->size);
	printf("ICON1.PMF :\n");
	printf("  addr: 0x%08X\n", ICON1->addr);
	printf("  size: 0x%08X\n", ICON1->size);
	printf("PIC0.PNG :\n");
	printf("  addr: 0x%08X\n", PIC0->addr);
	printf("  size: 0x%08X\n", PIC0->size);
	printf("PIC1.PNG :\n");
	printf("  addr: 0x%08X\n", PIC1->addr);
	printf("  size: 0x%08X\n", PIC1->size);
	printf("SND0.AT3 :\n");
	printf("  addr: 0x%08X\n", SND0->addr);
	printf("  size: 0x%08X\n", SND0->size);

	u8* buf = (u8*)malloc(1048576); // 1MB
	char path[2048] = "";
	char eboot[2048] = "";
	strncpy(path, argv[1], (int)(strlastof(argv[1],'.')-argv[1]));
	sprintf(eboot, "%s/EBOOT.PBP", path);
	mkdir(path);
	FILE* out = fopen(eboot, "wb");

	pbp_header.offset[1] = pbp_header.offset[0] + sizeof(PARAM);
	pbp_header.offset[2] = pbp_header.offset[1] + ICON0->size;
	pbp_header.offset[3] = pbp_header.offset[2] + ICON1->size;
	pbp_header.offset[4] = pbp_header.offset[3] + PIC0->size;
	pbp_header.offset[5] = pbp_header.offset[4] + PIC1->size;
	pbp_header.offset[6] = pbp_header.offset[5] + SND0->size;
	pbp_header.offset[7] = pbp_header.offset[6] + sizeof(loader);
	fwrite(&pbp_header, sizeof(pbp_header), 1, out);

	fwrite(PARAM, 1, sizeof(PARAM), out);
	ReadFile(ICON0, buf);
	fwrite(buf, 1, ICON0->size, out);
	ReadFile(ICON1, buf);
	fwrite(buf, 1, ICON1->size, out);
	ReadFile(PIC0, buf);
	fwrite(buf, 1, PIC0->size, out);
	ReadFile(PIC1, buf);
	fwrite(buf, 1, PIC1->size, out);
	ReadFile(SND0, buf);
	fwrite(buf, 1, SND0->size, out);
	fwrite(loader, 1, sizeof(loader), out);

	fseek(fd, 0, SEEK_SET);
	free(buf);
	buf = (u8*)malloc(10*1048576); // 10MB
	u32 i = 0;
	printf("Packing ISO/CSO...\n");
	for(i=0; i<iso_size; i+=10*1048576){
		printf("%2.2f %% Done\n", ((float)i)*100.0/((float)iso_size));
		if((iso_size-i) < 10*1048576){
			fread(buf, 1, (iso_size-i), fd);
			fwrite(buf, 1, (iso_size-i), out);
			break;
		}
		fread(buf, 1, 10*1048576, fd);
		fwrite(buf, 1, 10*1048576, out);
	}
		printf("100 %% Done\n");

	fclose(fd);
	fclose(out);
	printf("\n");
	system("pause");

	free(buf);
	return 0;
}

char* strlastof(const char* buffer, char last_c){
	int i = 0;
	int len = strlen(buffer);
	int last = 0;
	for(i=0; i<len; i++){
		if(buffer[i]==last_c)last=i;
	}
	return (char*)buffer+last;
}
